from flask import Flask, request, render_template, abort, jsonify
from recommender import recommend_top_three
from get_categories import get_categories

app = Flask(__name__)


@app.route("/status", methods = ['GET'])
def status():
    return {"Status" : "UP"}


@app.route('/')
def home():
    return render_template('home.html')


@app.route("/predict", methods = ['POST'])
def predict():
    data = request.json
    mood = data['self_awerness']
    responsible_desion_making = data["responsible_desion_making"]
    self_menegement = data['self_menegement']
    social_awerness = data['social_awerness']
    relationship_skills = data['relationship_skills']
    categories = data["categories"]
    text = mood + " " + responsible_desion_making + " " + self_menegement + " " + social_awerness + " " + " ".join(relationship_skills)
    print(text)
    top_five_post = recommend_top_three(categories, text)
    return top_five_post


@app.route("/recommand", methods = ['POST'])
def recommand():
    data = request.json
    texts = data["texts"]
    try:
        categories = get_categories(texts)
        print(categories)
    except Exception as err:
        print(f"Error {err}")
        abort(409, description=err)
    top_five_post = recommend_top_three(categories, texts)
    return top_five_post
   

@app.errorhandler(409)
def handle_409_error(e):
    # Custom error response for 400 Conflict
    response = jsonify(str(e.description))
    response.status_code = 409
    return response

if __name__=="__main__":
    app.run(port=5001)